$KCODE = 'u'

#***********************************************************************
# JAPRO Template Engine
#     Ver. 2.0
#
# ex.
#
# $jte = new JTE() ;
# $template->exexute( 'template/sample.html', $data ) ;
#
#***********************************************************************

if __FILE__ =~ /\A(.*\/)([^\/]*)\z/mu
  load "#{$1}jte_dom.rb"
else
  load "jte_dom.rb"
end

class JTE
  def initialize
    @templateAttribute = 'jte'
  
    @encoding = 'UTF-8'
    @docType = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">'
    @xhtml = true
    
    @emptyTag = [
      'meta',
      'base',
      'link',
      'basefont',
      'spacer',
      'br',
      'wbr',
      'hr',
      'img',
      'area',
      'param',
      'bgsound',
      'input'
    ]
  
    @blankAttribute = [
      'checked',
      'compact',
      'declare',
      'defer',
      'disabled',
      'ismap',
      'multiple',
      'nohref',
      'noresize',
      'noshade',
      'nowrap',
      'selected',
      'target'
    ]
  
    @urlAttribute = [
      'href',
      'src',
      'background',
      'cite',
      'action'
    ]
  
    @data = {
      'condition' => {},
      'value' => {},
      'record' => {},
      'function' => {}
    }
    
    @dom = JTE_DOMDocument.new
  end
  
  
  #=====================================================================
  # set
  
  def set_function( name, func )
    @data[ 'function' ][ name ] = func
  end
  
  
  def set_condition( name, condition )
    @data[ 'condition' ][ name ] = condition
  end
  
  
  def set_value( name, value )
    @data[ 'value' ][ name ] = value
  end
  
  
  def set_record( name, record )
    @data[ 'record' ][ name ] = record
  end
  
  
  # set hash
  
  def set_functions( hash )
    hash.each { | name, func |
      self.set_function( name, func )
    }
  end
  
  
  def set_conditions( hash )
    hash.each { | name, condition |
      self.set_condition( name, condition )
    }
  end
  
  
  def set_values( hash )
    hash.each { | name, value |
      self.set_value( name, value )
    }
  end
  
  
  def set_records( hash )
    hash.each { | name, record |
      self.set_record( name, record )
    }
  end
  
  
  # set all
  
  def set( data )
    if data.key?( 'function' )
      self.set_functions( data[ 'function' ] )
    end
    
    if data.key?( 'condition' )
      self.set_conditions( data[ 'condition' ] )
    end
    
    if data.key?( 'value' )
      self.set_values( data[ 'value' ] )
    end
    
    if data.key?( 'record' )
      self.set_records( data[ 'record' ] )
    end
  end
  
  
  #=====================================================================
  # load
  
  def load( path )
    f = open( path.untaint )
    html = f.read
    f.close
    
    html = self.delete_bom( html )
    
    @dom.encoding = @encoding
    
    html = html.strip
    
    if html =~ /\A(<\?xml(\s+.*?)?\?>)\s*(.*)\z/mui
      html = $2
    end
    
    if html =~ /\A(<\!DOCTYPE\s+.*?>)\s*(.*)\z/mui
      @doctype = $1
      html = $2
    end
    
    unless html =~ /\A<html(\s+.*?)?>/mu
      return false
    end
    
    self._parse( @dom, html )
    
    return true
  end
  
  
  #=====================================================================
  # _parse
  
  def _parse( parent, html, open = '' )
    while html != ''
      unless /\A(.*?)(<.*?>)(.*)\z/mu =~ html
        parent.appendChild( @dom.createTextNode( html ) )
        html.replace( '' )
        break
      end
      
      text = $1
      tag = $2
      html.replace( $3 )
      
      unless text == ''
        parent.appendChild( @dom.createTextNode( text ) )
      end
      
      if tag =~ /\A<\!--(.*?)-->\z/mu
        text = $1
        parent.appendChild( @dom.createComment( text ) )
        next
      end
      
      if tag =~ /\A<\!\[CDATA\[(.*?)\]\]>\z/mu
        text = $1
        parent.appendChild( @dom.createCDATASection( text ) )
        next
      end
      
      if tag =~ /\A<\/\s*(.*?)\s*>\z/mu
        tagName = $1.downcase
        
        if ( open == '' ) or ( open != tagName )
          print "Not opened or invalid &lt;#{open}&gt; - &lt;/#{tagName}&gt;<br />\n"
        end
        
        break
      end
      
      self._parse_element( parent, tag, html )
    end
  end
  
  
  def _parse_element( parent, tag, html )
    unless tag =~ /\A<\s*(\S+)\s*(.*?)>\z/mu
      # <理解不能>
      return
    end
    
    tagName = $1.downcase
    attributes = $2
    closed = false
    
    if attributes =~ /\A(.*?)\s*( ?\/)\z/mu
      attributes = $1
      closed = true
    end
    
    node = @dom.createElement( tagName )
    self._parse_attributes( node, attributes )
    
    unless closed
      unless @emptyTag.include?( tagName )
        if tagName == 'script'
          if html =~ /\A(.*?)<\/\s*script\s*>(.*)\z/mui
            text = $1
            html.replace( $2 )
            
            unless text == ''
              node.appendChild( @dom.createTextNode( text ) )
            end
          else
            unless html == ''
              node.appendChild( @dom.createTextNode( html ) )
            end
            
            html.replace( '' )
          end
        else
          self._parse( node, html, tagName )
        end
      end
    end
    
    parent.appendChild( node )
  end
  
  
  def _parse_attributes( node, attributes )
    while attributes != ''
      if attributes =~ /\A(\S+?)\s*=\s*("[^"]*"|\'[^\']*\'|\S?)\s*(.*?)\s*\z/mu
        name = $1.downcase
        value = $2
        attributes.replace( $3 )
        
        if value =~ /\A"([^"]*)"\z/mu
          value = $1
        else
          if value =~ /\A'([^']*)'\z/mu
            value = $1
            
            if @urlAttribute.include?( name )
              value.gsub( /"/, '%22' )
            else
              value.gsub( /"/, '&quot' )
            end
          end
        end
        
        node.setAttribute( name, value )
        
        next
      end
      
      if ( attributes =~ /\A(\S+)\s*(.*?)\s*\z/mu )
        name = $1.downcase
        attributes.replace( $2 )
        
        if $1 != ''
          node.setAttribute( name, name )
        end
        
        next
      end
      
      break
    end
  end
  
  
  #=====================================================================
  # replace template by data
  
  def replace()
    @data[ 'root' ] = @data
    
    @data[ 'parent' ] = {
      'condition' => {},
      'value'     => {},
      'record'    => {},
      'function'  => {}
    }
    
    records = {}
    
    self.replace_element( @dom.documentElement, @data, records )
  
    for record in records.values
      self.replace_records( record )
    end
  end
  
  
  # replace_element
  
  def replace_element( element, data, records, in_record = false, is_record = false )
    unless element.hasAttribute( @templateAttribute )
      self.replace_childs( element, data, records, in_record )
      return
    end
    
    commands = self._get_template_commands( element )
    
    unless is_record
      
      # fake
      
      if commands.key?( 'fake' )
        self.replace_command_fake( element, data, commands[ 'record' ], records, in_record )
        return
      end
      
      # record
      
      if commands.key?( 'record' )
        self.replace_command_record( element, data, commands[ 'record' ], records, in_record )
        return
      end
      
      # if/else
      
      if commands.key?( 'condition' )
        unless self.replace_command_condition( element, data, commands[ 'condition' ], records, in_record )
          return
        end
      end
      
      # parse_outer
      
      if commands.key?( 'parse_outer' )
        self.replace_command_parse_outer( element, data, commands[ 'parse_outer' ], records, in_record )
        return
      end
      
      # outer
      
      if commands.key?( 'outer' )
        if in_record
          self.replace_command_parse_outer( element, data, commands[ 'outer' ], records, in_record )
        else
          element.setAttribute( @templateAttribute, "outer: #{commands[ 'outer' ]}" )
        end
        
        return
      end
    end
    
    # @ - attribute
    
    if commands.key?( '@' )
      self.replace_command_attribute( element, data, commands[ '@' ], records, in_record )
    end
    
    # other - function / extended method
    
    if commands.key?( 'other' )
      self.replace_command_other( element, data, commands[ 'other' ], records, in_record )
    end
    
    # text( CGI.escapeHTML( value ).gsub( /\r?\n/, "<br />\n" ) )
    
    if commands.key?( 'text' )
      self.replace_command_text( element, data, commands[ 'text' ], records, in_record )
      return
    end
    
    # textarea( CGI.escapeHTML( value ) )
    
    if commands.key?( 'textarea' )
      self.replace_command_textarea( element, data, commands[ 'textarea' ], records, in_record )
      return
    end
    
    # inner
    
    if commands.key?( 'inner' )
      if in_record
        self.replace_command_parse_inner( element, data, commands[ 'inner' ], records, in_record )
      else
        element.setAttribute( @templateAttribute, "inner: #{commands[ 'inner' ]}" )
        return
      end
    end
    
    # parse_inner
    
    if commands.key?( 'parse_inner' )
      self.replace_command_parse_outer( element, data, commands[ 'parse_inner' ], records, in_record )
    end
    
    # child
    
    self.replace_childs( element, data, records, in_record )
  end
  
  
  # replace_remove
  
  def replace_remove( element )
    unless element.previousSibling == nil
      if element.previousSibling.nodeType == JTE_DOM::XML_TEXT_NODE
        if element.previousSibling.nodeValue.strip == ''
          element.parentNode.removeChild( element.previousSibling )
        end
      end
    end
    
    element.parentNode.removeChild( element )
  end
  
  
  # replace_childs
  
  def replace_childs( element, data, records, in_record = false )
    childs = []
    
    for n in 0 ... element.childNodes.length
      if element.childNodes.item( n ).nodeType == JTE_DOM::XML_ELEMENT_NODE
        childs.push( element.childNodes.item( n ) )
      end
    end
    
    for n in 0 ... childs.length
      self.replace_element( childs[ n ], data, records, in_record )
    end
  end
  
  
  # replace_records
  
  def replace_records( record )
    if record[ 'elements' ].length < record[ 'data' ].length
      parent = record[ 'data' ][ record[ 'elements' ].length - 1 ][ 'parent' ]
      last = record[ 'elements' ][ record[ 'elements' ].length - 1 ][ 'element' ]
      
      anchor = @dom.createElement( last.tagName )
      
      if last.nextSibling == nil
        last.parentNode.appendChild( anchor )
      else
        last.parentNode.insertBefore( anchor, last.nextSibling )
      end
      
      source = []
      
      unless last.previousSibling == nil
        if last.previousSibling.nodeType == JTE_DOM::XML_TEXT_NODE
          if last.previousSibling.nodeValue.strip == ''
            source.push( last.previousSibling.cloneNode() )
          end
        end
      end
      
      for n in record[ 'elements' ].length ... record[ 'data' ].length
        for s in 0 ... source.length
          anchor.parentNode.insertBefore( source[ s ].cloneNode( true ), anchor )
        end
        
        element = last.cloneNode( true ) ;
        anchor.parentNode.insertBefore( element, anchor )
        
        record[ 'data' ][ n ][ 'root' ] = @data
        record[ 'data' ][ n ][ 'parent' ] = parent
        
        record[ 'elements' ].push(
          {
            'element' => element,
            'records' => {}
          }
        )
        
        self.replace_element(
          record[ 'elements' ][ n ][ 'element' ],
          record[ 'data' ][ n ],
          record[ 'elements' ][ n ][ 'records' ],
          true,
          true
        ) ;
      end
      
      anchor.parentNode.removeChild( anchor )
    end
    
    for n in 0 ... record[ 'elements' ].length
      for name in record[ 'elements' ][ n ][ 'records' ].keys
        self.replace_record( record[ 'elements' ][ n ][ 'records' ][ name ] ) ;
      end
    end
  end
  
  
  #=====================================================================
  # command
  
  # command[ 'fake' ]
  
  def replace_command_fake( element, data, command, records, in_record )
    self.replace_remove( element )
  end
  
  
  # command[ 'record' ]
  
  def replace_command_record( element, data, command, records, in_record )
    local, localName = self._get_template_value_local( data, command )
    
    unless local.key?( 'record' )
      self.replace_remove( element )
      return false
    end
    
    unless local[ 'record' ].key?( localName )
      self.replace_remove( element )
      return false
    end
    
    if local[ 'record' ][ localName ].length == 0
      self.replace_remove( element )
      return false
    end
    
    unless records.key?( command )
      records[ command ] = {
        'data'  => local[ 'record' ][ localName ],
        'elements' => []
      }
    end
    
    unless records[ command ][ 'elements' ].length < records[ command ][ 'data' ].length
      self.replace_remove( element )
      return false
    end
    
    n = records[ command ][ 'elements' ].length
    
    records[ command ][ 'data' ][ n ][ 'root' ] = @data
    records[ command ][ 'data' ][ n ][ 'parent' ] = data
    
    records[ command ][ 'elements' ].push(
      {
        'element' => element,
        'records' => {}
      }
    )
    
    self.replace_element(
      records[ command ][ 'elements' ][ n ][ 'element' ],
      records[ command ][ 'data' ][ n ],
      records[ command ][ 'elements' ][ n ][ 'records' ],
      true,
      true
    )
    
    return true
  end
  
  
  # command[ 'condition' ]
  
  def replace_command_condition( element, data, command, records, in_record )
    for n in 0 ... command.length
      name = command[ n ][ 'name' ]
      condition = command[ n ][ 'condition' ]
      
      local, localName = self._get_template_value_local( data, name )
      
      check = self.replace_command_condition_check( local, localName )
      
      unless check == condition
        self.replace_remove( element )
        return false
      end
    end
    
    return true
  end
  
  
  def replace_command_condition_check( local, localName )
    if local.key?( 'condition' )
      if local[ 'condition' ].key?( localName )
        return local[ 'condition' ][ localName ]
      end
    end
    
    if local.key?( 'record' )
      if local[ 'record' ].key?( localName )
        return ( local[ 'record' ][ localName ].length > 0 )
      end
    end
    
    if local.key?( 'value' )
      if local[ 'value' ].key?( localName )
        return ( "#{local[ 'value' ][ localName ]}" != '' )
      end
    end
    
    return false
  end
  
  
  # command[ 'parse_outer' ]
  
  def replace_command_parse_outer( element, data, command, records, in_record )
    html = self._get_template_contents( data, command )
    
    if html.nil?
      return
    end
    
    html = self.delete_bom( html ).rstrip
    
    childs = ()
    
    div = @dom.createElement( 'div' )
    
    self._parse( div, html )
    
    for n in 0 ... div.childNodes.length
      child = div.childNodes.item( n ).cloneNode( true )
      element.parentNode.insertBefore( child, element )
      
      if child.nodeType == JTE_DOM::XML_ELEMENT_NODE
        childs.push( child )
      end
    end
    
    element.parentNode.removeChild( element ) 
    
    for n in 0 ... childs.length
      self.replace_element( childs[ n ], data, records, in_record )
    end
  end
  
  
  # command[ '@' ]
  
  def replace_command_attribute( element, data, command, records, in_record )
    for n in 0 ... command.length
      attribute = command[ n ][ 'attribute' ]
      name = command[ n ][ 'name' ]
      
      local, localName = self._get_template_value_local( data, name )
      
      unless local.key?( 'value' )
        next
      end
      
      unless local[ 'value' ].key?( localName )
        next
      end
      
      if "#{local[ 'value' ][ localName ]}" == ''
        if @blankAttribute.include?( attribute )
          if element.hasAttribute( attribute )
            element.removeAttribute( attribute )
          end
          
          next
        end
      end
      
      element.setAttribute( attribute, local[ 'value' ][ localName ] )
    end
  end
  
  
  # command[ 'other' ]
  
  def replace_command_other( element, data, command, records, in_record )
    for n in 0 ... command.length
      type = command[ n ][ 'command' ]
      name = command[ n ][ 'name' ]
      
      case type
        when 'function'
          local, localName = self._get_template_value_local( data, name )
          
          if local.key?( 'function' )
            if local[ 'function' ].key?( localName )
              
              # obj.method( name )
              
              if local[ 'function' ][ localName ].is_a?( Method )
                  local[ 'function' ][ localName ].call( self, element, data )
                  return
              end
              
              # [ obj, name ]
              
              if local[ 'function' ][ localName ].is_a?( Array )
                  obj = local[ 'function' ][ localName ][ 0 ]
                  method = local[ 'function' ][ localName ][ 1 ]
                  
                  if ( obj.respond_to?( method, true ) )
                    obj.send( method, self, element, data )
                  end
                  
                  return
              end
            end
          end
        else
          method = "command_#{type}"
          
          if self.respond_to?( method )
            self.send( method, element, data, type, name )
          end
      end
    end
  end
  
  
  # command[ 'text' ]
  
  def replace_command_text( element, data, command, records, in_record )
    local, localName = self._get_template_value_local( data, command )
    
    unless local.key?( 'value' )
      return
    end
    
    unless local[ 'value' ].key?( localName )
      return
    end
    
    br = ( @xhtml ) ? '<br />' : '<br>'
    
    html = CGI.escapeHTML( local[ 'value' ][ localName ] ).gsub( /\r?\n/, "#{br}\n" )
  
    while element.childNodes.length > 0
      element.removeChild( element.firstChild )
    end
    
    self._parse( element, html )
  end
  
  
  # command[ 'textarea' ]
  
  def replace_command_textarea( element, data, command, records, in_record )
    local, localName = self._get_template_value_local( data, command )
    
    unless local.key?( 'value' )
      return
    end
    
    unless local[ 'value' ].key?( localName )
      return
    end
    
    html = CGI.escapeHTML( local[ 'value' ][ localName ] )
  
    while element.childNodes.length > 0
      element.removeChild( element.firstChild )
    end
    
    self._parse( element, html )
  end
  
  
  # command[ 'parse_inner' ]
  
  def replace_command_parse_inner( element, data, command, records, in_record )
    html = self._get_template_contents( data, command )
    
    if html.nil?
      return
    end
    
    html = self.delete_bom( html ).rstrip
    html = self._inner_keep_indent( element, html )
    
    # 空にする
    
    while element.childNodes.length > 0
      element.removeChild( element.firstChild )
    end
    
    self._parse( element, html )
  end
  
  
  #=====================================================================
  # save
  
  def save()
    html = "#{@docType}\n"
    
    self._tree( html, @dom.documentElement, @data )
    
    return html
  end
  
  
  #=====================================================================
  # _tree
  
  def _tree( html, node, data )
    emptyTagEnd = ( @xhtml ) ? ' /' : ''
    
    if node.nodeType == JTE_DOM::XML_ELEMENT_NODE
      tag = [ node.tagName ]
      
      commands = self._get_template_commands( node )
      node.removeAttribute( @templateAttribute )
      
      if commands.key?( 'outer' )
        text = self._get_template_contents( data, commands[ 'outer' ] )
        
        unless ( text.nil? )
          html.concat( text )
        end
        
        return
      end
      
      for n in 0 ... node.attributes.length
        name = node.attributes.item( n ).name
        value = node.attributes.item( n ).value
        
        if value == ''
          if @blankAttribute.include?( name )
            next
          end
        end
        
        if @xhtml
          tag.push( "#{CGI.escapeHTML( name )}=\"#{value}\"" )
        else
          if @blankAttribute.include?( name )
            tag.push( CGI.escapeHTML( name ) )
          else
            tag.push( "#{CGI.escapeHTML( name )}=\"#{value}\"" )
          end
        end
      end
      
      if @emptyTag.include?( node.tagName )
        html.concat( "<#{tag.join( ' ' )}#{emptyTagEnd}>" )
      else
        html.concat( "<#{tag.join( ' ' )}>" )
        
        if commands.key?( 'inner' )
          text = self._get_template_contents( data, commands[ 'inner' ] )
          
          unless ( text.nil? )
            text = self.delete_bom( text ).rstrip
            text = self._inner_keep_indent( node, text )
            
            html.concat( text )
          end
        else
          for n in 0 ... node.childNodes.length
            self._tree( html, node.childNodes.item( n ), data )
          end
        end
        
        html.concat( "</#{node.tagName}>" )
      end
      
      return
    end
    
    if node.nodeType == JTE_DOM::XML_COMMENT_NODE
      html.concat( "<!--#{node.nodeValue}-->" )
      return
    end
    
    if node.nodeType == JTE_DOM::XML_CDATA_SECTION_NODE
      html.concat( "<![CDATA[#{node.nodeValue}]]>" )
      return
    end
    
    html.concat( node.nodeValue )
  end
  
  
  #=====================================================================
  # output html from template and data
  
  def execute( path, data )
    self.load( path )
    self.set( data )
    self.replace
    print self.save
  end
  
  
  #=====================================================================
  # part of html
  
  def part_load( html )
    html = self.delete_bom( html ).strip
    
    @dom = JTE_DOMDocument.new
    @dom.encoding = @encoding
    
    part = "<part>#{html}</part>"
    
    self._parse( @dom, part )
  end
  
  
  def part_replace( data )
    records = {}
    self.replace_childs( @dom, data, records )
  end
  
  
  def part_save( data, xhtml = true )
    @xhtml = xhtml
    
    html = ""
    
    for n in 0 ... @dom.documentElement.childNodes.length
      self._tree( html, @dom.documentElement.childNodes.item( n ), data )
    end
    
    return html
  end
  
  
  def part_execute( html, data, xhtml = true )
    self.part_load( html )
    self.part_replace( data )
    return self.part_save( data, xhtml )
  end
  
  
  #=====================================================================
  # _common
  
  def delete_bom( text )
    return text.sub( /\A\xef\xbb\xbf/, '' )
  end
  
  
  def _get_template_commands( element )
    attributes = element.getAttribute( @templateAttribute ).strip.split( /\s*;\s*/ )
    
    commands = {}
    
    for a in 0 ... attributes.length
      command_name = attributes[ a ].strip
      
      if command_name == ''
        next
      end
      
      if command_name =~ /\A([^:]*)\s*:\s*(.*)\z/
        command = $1
        name = $2
      else
        command = command_name
        name = ''
      end
      
      if command =~ /\A@(.+)$\z/
        attribute = $1.downcase
        
        unless commands.key?( '@' )
          commands[ '@' ] = []
        end
        
        commands[ '@' ].push( { 'attribute' => attribute, 'name' => name } )
        
        next
      end
      
      case command
        when 'fake', 'remove', 'dummy'
          commands[ 'fake' ] = true
        
        when 'record', 'parse_outer', 'parse_inner', 'outer', 'inner', 'text', 'textarea'
          commands[ command ] = name
        
        when 'if', 'else', 'condition', 'condition_not'
          condition = ( ( command == 'if' ) || ( command == 'condition' ) )
          unless commands.key?( 'condition' )
            commands[ 'condition' ] = []
          end
          
          commands[ 'condition' ].push( { 'condition' => condition, 'name' => name } )
        
        else
          unless commands.key?( 'other' )
            commands[ 'other' ] = []
          end
          
          commands[ 'other' ].push( { 'command' => command, 'name' => name } )
      end
    end
    
    return commands
  end
  
  
  def _get_template_contents( data, name )
    if name =~ /\Aurl\(([^)]*)\)\z/
      parts = []
      urls = $1.split( /(\s+|\s*,\s*)/ )
      
      for n in 0 ... urls.length
        url = urls[ n ].strip
        
        if url == ''
          next
        end
        
        part = ''
        
        begin
          f = open( url.untaint )
        rescue
          return nil
        else
          part = f.read
          f.close
        end
        
        if part == ''
          next
        end
        
        parts.push( self.delete_bom( part ).rstrip )
      end
      
      return parts.join( "\n" )
    end
    
    return self._get_template_value( data, name )
  end
  
  
  def _get_template_value( data, name )
    local, localName = self._get_template_value_local( data, name )
    
    unless local.key?( 'value' )
      return nil
    end
    
    unless local[ 'value' ].key?( localName )
      return nil
    end
    
    return local[ 'value' ][ localName ]
  end
  
  
  def _get_template_value_local( data, name )
    if name =~ /\A(\S+?)\.(.+)\z/mu
      case $1.downcase
        when 'root'
          return [ data[ 'root' ], $2.strip ]
        
        when 'parent'
          return [ data[ 'parent' ], $2.strip ]
      end
    end
    
    return [ data, name ]
  end
  
  
  def _inner_keep_indent( element, html )
    if element.childNodes.length == 0
      return html
    end
    
    first = ''
    last = ''
    
    # 開始タグの後の改行までの空白・コメントを保持
    
    while element.childNodes.length > 0
      if element.firstChild.nodeType == JTE_DOM::XML_TEXT_NODE
        text =element.firstChild.nodeValue
        
        # 改行がある場合(終了)
        
        if text =~ /\A(.*?)(\r?\n)(.*)\z/mu
          space = $1
          lf = $2
          other = $3
          
          if space =~ /\A\s*\z/mu
            first = "#{first}#{space}#{lf}"
            element.firstChild.nodeValue = "#{lf}#{other}"
          else
            first = "#{first}#{lf}"
          end
          
          break
        end
        
        # 空白でない場合(終了)
        
        unless text =~ /\A\s*\z/mu
          break
        end
        
        # 空白を保持
        
        first = "#{first}#{text}"
        element.removeChild( element.firstChild )
        
        next
      end
      
      # コメントを保持
      
      if element.firstChild.nodeType == JTE_DOM::XML_COMMENT_NODE
        first = "#{first}<!--#{element.firstChild.nodeValue}-->"
        element.removeChild( element.firstChild )
        
        next
      end
      
      break
    end
    
    # 閉じタグのインデントを保持
    
    while element.childNodes.length > 0
      if element.lastChild.nodeType == JTE_DOM::XML_TEXT_NODE
        text =element.lastChild.nodeValue
        
        # 改行がある場合(終了)
        
        if text =~ /\A(.*)(\r?\n)(.*?)\z/mu
          other = $1
          lf = $2
          space = $3
          
          if space =~ /\A\s*\z/mu
            last = "#{lf}#{space}#{last}"
            element.lastChild.nodeValue = "#{other}#{lf}"
          else
            last = "#{lf}#{last}"
          end
          
          break
        end
        
        # 空白でない場合(終了)
        
        unless text =~ /\A\s*\z/mu
          break
        end
        
        # 空白を保持
        
        last = "#{text}#{last}"
        element.removeChild( element.lastChild )
        
        next
      end
      
      # コメントを保持
      
      if element.lastChild.nodeType == JTE_DOM::XML_COMMENT_NODE
        last = "<!--#{element.lastChild.nodeValue}-->#{last}"
        element.removeChild( element.lastChild )
        
        next
      end
      
      break
    end
    
    return "#{first}#{html}#{last}"
  end
  
  
  attr_accessor :templateAttribute, :encoding, :docType, :xhtml, :dom
end